--  Tasks:
-- time_tick -      
--      , (   hand_add)
--      level.lua
--  Params: -   ,    
require( "scripts/game/deftasks.lua" );
require( "scripts/game/deftime.lua" );
require( "scripts/game/defpersonage.lua" );

GameObject = {
    Params = {
        ID="dad";           -- do not change this parameter
        width=1;            -- do not change this parameter
        height=1;           -- do not change this parameter
        health=5000;        -- 
        hungry=5000;        --  ( ,   )
        thirst=5000;        --  ( ,   )
        speed=750;         --  
        group=1;        -- do not change this parameter (   )
        timerTask=-1;       -- do not change this parameter ( )
        --on_drink=1.7;           --   
        --count_action_drink=3;   -- -   
        LemonadWork=0.7;    --       .
        drink_speed_bonus = 1.7;
        lemonad_time = 10;
        bonus_it = 0;           -- do not change this parameter
        GridData = { 1 };       -- do not change this parameter
        idle_timer = { 3, 8, 10 }; --         -          
        idle_animation = { 100, 100, 100, 100, 100 }; --  ,  -  -   
        home = true;
        enabled = 0;        -- do not change this parameter(  )
    };
    Objects = {};
    -- list of all tasks for an object
    Tasks = { 
        eating   = { FuncName="eatingExecute",     timer = 3,  time_tick=400 }; 
        watering  = { FuncName="wateringExecute",  timer = 3  }; 
        eating_cow_end   = { FuncName="endEatingCowExecute",  timer = 5 }; 
        milking_cow   = { FuncName="milkingCowExecute",  timer = 10 }; 
        fixed1_car   = { FuncName="fixed1CarExecute",    timer = 7 }; 
        fixed2_car   = { FuncName="fixed2CarExecute",    timer = 8 }; 
        fixed1_car1   = { FuncName="fixed1Car1Execute",    timer = 7 }; 
        watering_cow_end   = { FuncName="endWateringCowExecute",   timer = 5 }; 
        eating_sheep_end   = { FuncName="endEatingSheepExecute",   timer = 3 }; 
        shearing_sheep   = { FuncName="shearingSheepExecute",      timer = 8 }; 
        watering_sheep_end   = { FuncName="endWateringSheepExecute",   timer = 3 }; 
        tools_sheep_end   = { FuncName="endCleaningSheepExecute",   timer = 3 }; 
        talk_telephon = { FuncName="TalkTelephonExecute", timer = {2,3}};              
        talk_brother = { FuncName="TalkMobilaExecute", timer = {6,5}};      
        tools_cow_end   = { FuncName="endCleaningCowExecute",   timer = 3 }; 
        dad_home_dhp = { FuncName="DadGoHomeExecute", timer = {1}, hand_add=1 };
        --take_plank_firewood = { FuncName="referFirewoodExecute", time_tick=20,  timer = 1 }; 
        hackfirewood_chopping = { FuncName="hackFirewoodExecute", time_tick=1000, timer = 7 }; 
        heating_house = { FuncName="heatingHouseExecute",   timer = 2 }; 
        eating_hen_end   = { FuncName="endEatingHenExecute",   timer = 3 }; 
        egging_hen   = { FuncName="eggingHenExecute",      timer = 8 }; 
        watering_hen_end   = { FuncName="endWateringHenExecute",   timer = 3, time_tick=800 }; 
        --Tomato
        watering_tomato_end   = { FuncName="endWateringTomatoExecute",   timer = 3 };         
        tools_tomato_end   = { FuncName="endFertilizingTomatoExecute",   timer = 3 };         
        weeding_tomato = { FuncName="WeedingTomatoExecute", timer = 4 };        
        collection_tomato = { FuncName="CollectionTomatoExecute", timer=5 };
        --
        tools   = { FuncName="TakeToolsExecute",  timer = 2 }; 
        tools_ground_end   = { FuncName="endPlantGroundExecute",  timer = 5 }; 
        weeding_ground = { FuncName="WeedingGroundExecute", timer = 4, time_tick=600 };        
        --eatmachine
        eating_eatmachine_end = { FuncName="switchOnEatMachineExecute",  timer = 1 }; 
        --trash
        trashing_trash_end = { FuncName="trashingExecute",     timer = 1,  time_tick=200 }; 
        --  
        eggtake = { FuncName="eggtakeExecute",     timer = 1,  time_tick=100 }; 
        milktake = { FuncName="milktakeExecute",     timer = 1,  time_tick=100 }; 
        sheartake = { FuncName="sheartakeExecute",     timer = 1,  time_tick=100 }; 
        tomatostake = { FuncName="tomatostakeExecute",     timer = 1,  time_tick=100 }; 
        milkgoattake = { FuncName="milkgoattakeExecute",     timer = 1,  time_tick=100 }; 
        cheesetake = { FuncName="cheesetakeExecute",     timer = 1,  time_tick=100 }; 
        keeping_redbarn_end = { FuncName="keepingRedbarnExecute",     timer = 1,  time_tick=1300 }; 
        relax_kreslo = { FuncName="RelaxInKreslo", timer=3, time_tick=1000, hand_add=1 };
        cornstake = { FuncName="cornstakeExecute",     timer = 1,  time_tick=100 }; 
        --
        eating_goat_end   = { FuncName="endEatingGoatExecute",   timer = 3 }; 
        milking_goat   = { FuncName="milkingGoatExecute",      timer = 8 }; 
        watering_goat_end   = { FuncName="endWateringGoatExecute",   timer = 3 }; 
        switch_on_cheesemachine_end = { FuncName="switchCheeseMachExecute",     timer = 1,  time_tick=100 }; 
        --lemonad
        make_lemonad = { FuncName="MakeLemonadExecute",   timer = 1 }; 
        drink_lemonad = { FuncName="DrinkLemonadExecute", timer = 2, hand_add=1};
        --   
        plank   = { FuncName="plankExecute",     timer = 1,  time_tick=100 }; 
        
        plank_cowshed_end   = { FuncName="plankCowchedExecute",     timer = 8,  time_tick=500 }; 
        plank_henhouse1_end   = { FuncName="plankHenhouseExecute",     timer = 8,  time_tick=500 }; 
        plank_sheephouse_end   = { FuncName="plankSheephouseExecute",     timer = 8,  time_tick=500 }; 
        plank_goathouse_end   = { FuncName="plankGoathouseExecute",     timer = 8,  time_tick=500 }; 
        --corn
        watering_corn_end   = { FuncName="endWateringCornExecute",   timer = 3 };         
        tools_corn_end = { FuncName="endFertilizingCornExecute",   timer = 2 };         
        weeding_corn = { FuncName="WeedingTomatoExecute", timer = 4 };        
        collection_corn = { FuncName="CollectionTomatoExecute", timer=5 };
        
        watering_pumpkins_end   = { FuncName="endWateringPumpkinsExecute",   timer = 3 };         
        tools_pumpkins_end = { FuncName="endFertilizingPumpkinsExecute",   timer = 3 };         
        weeding_pumpkins = { FuncName="WeedingPumpkinsExecute", timer = 3, time_tick=300  };        
        collection_pumpkins = { FuncName="CollectionPumpkinsExecute", timer=5 };
        
        pumpkintake = { FuncName="pumpkintakeExecute",     timer = 1,  time_tick=100 }; 
       
    };
--       
    -- list of all triggers for an object
    Triggers = { 
        drink_triger = {FuncName="DrinkTriger"};            
    };
    --tasks to be performed after an object is created
    InitActiveTasks = {}; 
    --tasks an object is waiting ofr after it is created
    InitExpectedTasks = {};
};
function GameObject:Get()
    return self;
end

function GetParams()
    aObj = GameObject:Get();   
    return aObj.Params;
end
-- perform Task EATING over external object and return true if task is completed
function eatingExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.eating.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask == 3) then 
        CPP_SecondObjAnimState("nasip_seno1");
    else 
        if (tTask == 1) then CPP_SecondObjAnimState("nasip_seno2"); end;
    end
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        return 0;
    end
    return 1;
end


-- perform Task MILKING  over external object and return true if task is completed
function milkingCowExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.milking_cow.timer; 
        CPP_SecondObjChildAnimState("milk","milk",1,0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask == 2) then 
        CPP_SecondObjChildAnimState("milk","milk",2,0);
    end
    if (tTask <= 0) then
        CPP_SecondObjChildAnimState("milk","milk",3,0);
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("right_stand");
        OnEndTask("milking",aObject.Tasks.milking_cow);                     
        return 0;
    end
    return 1;
end

-- perform Task MILKING  over external object and return true if  task is completed
function shearingSheepExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.shearing_sheep.timer;
        CPP_SecondObjChildAnimState("shear","shear",1,0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    
    if (tTask == 2) then CPP_SecondObjChildAnimState("shear","shear",2,0); end

    if (tTask <= 0) then
        CPP_SecondObjChildAnimState("shear","shear",3,0);
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("right_stand");
        OnEndTask("shearing",aObject.Tasks.shearing_sheep);                             
        return 0;
    end
    return 1;
end
-- perform Task WATERING  over external object and return true if task is completed
function wateringExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.watering.timer; 
        CPP_SetAnimState("watering_handcall");
        CPP_SecondObjAnimState("rolling");
        CPP_PlaySound("well",0);        
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask == 1) then CPP_SecondObjAnimState("rolling_end"); end;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("left_stand");
        CPP_SecondObjAnimState("normal");
        return 0;
    end
    return 1;
end


--    Task WATERING       true  
function endWateringTomatoExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.watering_tomato_end.timer; 
        CPP_PlaySound("water_pour",0);        
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("up_stand");
        OnEndTask("watering",aObject.Tasks.watering_tomato_end);                                             
        return 0;
    end
    return 1;
end

--    Task WEEDING       true  
function WeedingTomatoExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.weeding_tomato.timer; 
        CPP_PlaySound("weeding",1);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("right_stand");
        OnEndTask("weeding",aObject.Tasks.weeding_tomato);                             
        CPP_StopSound("weeding");
        return 0;
    end
    return 1;
end

function CollectionTomatoExecute()
    return DefCollectionExecute("collection_tomato", "tomatos");
end


-- perform Task FIXED_CAR step 1 over external object and return true if task is completed
function fixed1CarExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.fixed1_car.timer; 
        CPP_PlaySound("car_fixing",1);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("left_stand");
        OnEndTask("fixed1_car",aObject.Tasks.fixed1_car);                       
        CPP_StopSound("car_fixing");
        return 0;
    end
    return 1;
end
-- perform Task FIXED_CAR step 2 over external object and return true if task is completed
function fixed2CarExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.fixed2_car.timer; 
        CPP_PlaySound("car_fixing",1);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("left_stand");
        OnEndTask("fixed2_car",aObject.Tasks.fixed2_car);                       
        CPP_StopSound("car_fixing");
        return 0;
    end
    return 1;
end


function RelaxKresloExecute()
        aObject = GameObject:Get();
        
        if( not aObject.Params.iRelaxTime or aObject.Params.iRelaxTime==0 )then
            aObject.Params.iRelaxTime = GetRandomValue(aObject.Tasks.relax_kreslo.timer);
            CPP_SecondObjAnimState("invisible");            
            CPP_SetAnimState("relax_kreslo_");
        end
        
        aObject.Params.iRelaxTime = aObject.Params.iRelaxTime-1;
        
        if( aObject.Params.iRelaxTime == 0)then
            CPP_SecondObjAnimState("normal");           
            return 0;
        end
    return 1;
end



function RelaxKresloTriger()
    aObj = GameObject:Get();
    return defWishTriger(aObj.Triggers.RelaxKreslo, "relax",1 );
end


function DadGoHomeExecute()
    aObject = GameObject:Get();
    CPP_Sleep(10000,1);
    aObject.Params.timerTask = -1;
    return 0;
end

function hackFirewoodExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.hackfirewood_chopping.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask == 5) then CPP_OtherObjAnimState("firewood","chopping1"); end
    if (tTask == 4) then CPP_OtherObjAnimState("firewood","chopping2"); end
    if (tTask == 3) then CPP_OtherObjAnimState("firewood","chopping3"); end
    if (tTask == 1) then CPP_OtherObjAnimState("firewood","chopping4"); end
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("right_stand");
        OnEndTask("hackfirewood",aObject.Tasks.hackfirewood_chopping);

        CPP_OtherObjAnimState("firewood","chopping4");
        --   
        --     chopping:HackfirewoodTaskExecute   
        --        
        CPP_OtherObjPutOnTopExpectedTasks("firewood","take_plank",1);
        CPP_AddRemittedTasks("dad","firewood","","plank_task_icon");
        
        return 0;
    end
    return 1;
end

-- perform Task heating over external object and return true if task is completed
function heatingHouseExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.heating_house.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        OnEndTask("heating",aObject.Tasks.heating_house);
        CPP_SetAnimState("no_task_icon");
        return 0;
    end
    return 1;
end

--  
--   Task EATING      true  
function endEatingHenExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.eating_hen_end.timer; 
        CPP_PlaySound("hay",0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask == 2) then 
        CPP_SecondObjAnimState("nasip_seno2");
    else 
        if (tTask == 1) then 
            CPP_SecondObjAnimState("nasip_seno1");
        else 
            CPP_SecondObjAnimState("eating_hen"); 
        end
    end
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        OnEndTask("eating",aObject.Tasks.eating_hen_end);             
        CPP_SetAnimState("right_stand");
        return 0;
    end
    return 1;
end


--    Task WATERING       true  
function endWateringHenExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.watering_hen_end.timer; 
        CPP_SecondObjAnimState("watering_hen");
        CPP_PlaySound("water_pour",0);        
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("up_stand");
        OnEndTask("watering",aObject.Tasks.watering_hen_end);                                             
        return 0;
    end
    return 1;
end
-- perform Task MILKING  over external object and return true if  task is completed
function eggingHenExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        CPP_SecondObjChildAnimState("egg","egg",1,0);
        tTask = aObject.Tasks.egging_hen.timer; 
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    
    if (tTask == 2) then 
        CPP_SecondObjChildAnimState("egg","egg",2,0);
    end
    if (tTask <= 0) then
        CPP_SecondObjChildAnimState("egg","egg",3,0);
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("right_stand");
        OnEndTask("egging",aObject.Tasks.egging_hen);                             
        return 0;
    end
    return 1;
end

-- perform Task FIXED_CAR step 1 over external object and return true if task is completed
function fixed1Car1Execute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.fixed1_car1.timer; 
        CPP_PlaySound("car_fixing",1);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("left_stand");
        OnEndTask("fixed1_car1",aObject.Tasks.fixed1_car1);                       
        CPP_StopSound("car_fixing");
        return 0;
    end
    return 1;
end
-- perform Task over external object and return true if task is completed
function TakeToolsExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.tools.timer; 
        CPP_PlaySound("workshop_get_tools",0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;

    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("right_stand");
        OnEndTask("tools",aObject.Tasks.tools);                     
        return 0;
    end
    return 1;
end

--   Task      true  
function endPlantGroundExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.tools_ground_end.timer; 
        CPP_PlaySound("planting",0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        OnEndTask("tools",aObject.Tasks.tools_ground_end);       
        return 0;
    end
    return 1;
end

function WeedingGroundExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        CPP_PlaySound("weeding",1);
        tTask = aObject.Tasks.weeding_ground.timer; 
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        CPP_StopSound("weeding");
        OnEndTask("weeding_ground",aObject.Tasks.weeding_ground);                             
        return 0;
    end
    return 1;
end

-- EATMACHINE
function switchOnEatMachineExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.eating_eatmachine_end.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("left_stand");
        OnEndTask("eating_eatmachine_end",aObject.Tasks.eating_eatmachine_end);                       
        return 0;
    end
    return 1;
end

function trashingExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.trashing_trash_end.timer; 
        CPP_PlaySound("garbage",0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        return 0;
    end
    return 1;
end
--  
function keepingRedbarnExecute()
    return defKeepingRedbarnExecute();
end

function eggtakeExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.eggtake.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        CPP_AddRemittedTasks("dad","redbarn","","");   
        return 0;
    end
    return 1;
end

function milktakeExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.milktake.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        CPP_AddRemittedTasks("dad","redbarn","","");   
        return 0;
    end
    return 1;
end

function sheartakeExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.sheartake.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        CPP_AddRemittedTasks("dad","redbarn","","");   
        return 0;
    end
    return 1;
end

function tomatostakeExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.tomatostake.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        CPP_AddRemittedTasks("dad","redbarn","","");   
        return 0;
    end
    return 1;
end

function cornstakeExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.cornstake.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        CPP_AddRemittedTasks("dad","redbarn","","");   
        return 0;
    end
    return 1;
end

function milkgoattakeExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.milkgoattake.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        if (CPP_IsObjectExist("cheesemachine")) then
            CPP_AddRemittedTasks("dad","cheesemachine","","");   
        else
            CPP_AddRemittedTasks("dad","redbarn","","goatmilktake_task_icon");   
        end
        return 0;
    end
    return 1;
end

function cheesetakeExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.cheesetake.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        CPP_AddRemittedTasks("dad","redbarn","","");   
        return 0;
    end
    return 1;
end

function RelaxInKreslo()
    return DefRelaxTask("dad_rest");
end

---------------------------------------------------------------------------------------------------------------------------------------
--   Task EATING      true  
function endEatingGoatExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.eating_goat_end.timer; 
        CPP_PlaySound("hay",0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask == 2) then 
        CPP_SecondObjAnimState("eating_sheep");
    else 
        if (tTask == 1) then 
            CPP_SecondObjAnimState("nasip_seno1");
        else 
            CPP_SecondObjAnimState("nasip_seno2"); 
        end
    end
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        OnEndTask("eating",aObject.Tasks.eating_goat_end);             
        CPP_SetAnimState("right_stand");
        return 0;
    end
    return 1;
end
-- perform Task MILKING  over external object and return true if  task is completed
function milkingGoatExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.milking_goat.timer;
        CPP_SecondObjChildAnimState("milkgoat","milk",1,0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    
    if (tTask == 2) then CPP_SecondObjChildAnimState("milkgoat","milk",2,0); end

    if (tTask <= 0) then
        CPP_SecondObjChildAnimState("milkgoat","milk",3,0);
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("right_stand");
        OnEndTask("milking",aObject.Tasks.milking_goat);                             
        return 0;
    end
    return 1;
end
--    Task WATERING       true  
function endWateringGoatExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.watering_goat_end.timer; 
        CPP_SecondObjAnimState("watering_sheep");
        CPP_PlaySound("water_pour",0);        
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("up_stand");
        OnEndTask("watering",aObject.Tasks.watering_goat_end);                                             
        return 0;
    end
    return 1;
end

function switchCheeseMachExecute()
    CPP_SetAnimState("left_stand");
    return 0;
end

function MakeLemonadExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.make_lemonad.timer; 
        CPP_PlaySound("juicer",0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        return 0;
    end
    return 1;
end

function endCleaningSheepExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.tools_sheep_end.timer; 
        --CPP_SecondObjAnimState("watering_sheep");
        CPP_PlaySound("washing",1);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_StopSound("washing");
        CPP_SetAnimState("up_stand");
        OnEndTask("tools",aObject.Tasks.tools_sheep_end);                                             
        return 0;
    end
    return 1;
end

function endCleaningCowExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.tools_cow_end.timer; 
        --CPP_SecondObjAnimState("watering_sheep");
        CPP_PlaySound("washing",1);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("up_stand");
        CPP_StopSound("washing");
        OnEndTask("tools",aObject.Tasks.tools_cow_end);                                             
        return 0;
    end
    return 1;
end

function endFertilizingTomatoExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.tools_tomato_end.timer; 
        CPP_PlaySound("fertilizer",0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("up_stand");
        OnEndTask("tools",aObject.Tasks.tools_tomato_end);                                             
        return 0;
    end
    return 1;
end
-- perform Task EATING over external object and return true if task is completed
function plankExecute()
    aObject = GameObject:Get();
    --local tTask = aObject.Params.timerTask;
    --if (tTask < 0) then tTask = aObject.Tasks.plank.timer; end
    --tTask = tTask - 1;
    --aObject.Params.timerTask = tTask;
    --if (tTask <= 0) then
        --aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        CPP_CheckQueue();
        return 0;
    --end
    --return 1;
end

function plankEndExecute(aTask)
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks[aTask].timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        return 0;
    end
    return 1;
end


function plankCowchedExecute()
    return plankEndExecute("plank_cowshed_end");
end

function plankHenhouseExecute()
    return plankEndExecute("plank_henhouse1_end");
end

function plankSheephouseExecute()
    return plankEndExecute("plank_sheephouse_end");
end

function plankGoathouseExecute()
    return plankEndExecute("plank_goathouse_end");
end


-- CORN
function endWateringCornExecute()
    return DefEndWateringExecute("watering_corn_end");
end

function endFertilizingCornExecute()
    return DefEndToolsExecute("tools_corn_end");
end

function WeedingCornExecute()
    return DefWeedingExecute("weeding_corn");
end

function CollectionCornExecute()
    return DefCollectionExecute("collection_corn", "corns");
end
------------------------------------------------------------------------------------------------------------------------------
-- Pumpkins
function endWateringPumpkinsExecute()
    return DefEndWateringExecute("watering_pumpkins_end");
end

function endFertilizingPumpkinsExecute()
    return DefEndToolsExecute("tools_pumpkins_end");
end

function WeedingPumpkinsExecute()
    return DefWeedingExecute("weeding_pumpkins");
end

function CollectionPumpkinsExecute()
    return DefCollectionExecute("collection_pumpkins", "pumpkin");
end
------------------------------------------------------------------------------------------------------------------------------
-- Pumpkin
function pumpkintakeExecute()
    return DefTakeExecute("pumpkintake");
end

function referFirewoodExecute()
    return 0;
end
